% Model of a semi batch bioreactor - penicillin production

% Main file

% For more information, see:

% A. De Visscher 
% Lecture Notes in Chemical Engineering Kinetics and Chemical Reactor Design
% Createspace (2013) 

% (C) Alex De Visscher (2013)

% ---------------------------

% data

clear all

tspan = 0:2:500;     % We want output every 2 h up to 500 h
X0 = 0.2;            % Initial biomass concentration (kg/m3)
cS0 = 0;             % Initial sucrose concentration (kg/m3)
cP0 = 0;             % Initial antibiotic concentration (kg/m3)

%                    % Rate constants 

Km = 10;             % Michaelis Menten constant (kg/m3)
KI = 6.5;            % Inhibition constant (kg/m3)
mumax = 0.06;        % Maximum growth rate (1/h)
kd = 0.006;          % Decay rate (1/h)
Yxs = 0.25;          % Cell yield constant
Ypx = 0.002;         % Antibiotic yield constant

%                    % Reactor conditions

Vinit = 1;           % Initial reactor volume (m3)
Q = 0.002;           % Incoming volumetric flow rate (m3/h)
cSin = 50;           % Inlet concentration sucrose (kg/m3)

%                    % Running variables for differential equations
                     % Initial conditions
                     
n0(1) = X0*Vinit;    % Initial mass of biomass (kg)
n0(2) = cS0*Vinit;   % Initial mass of sucrose (kg)
n0(3) = cP0*Vinit;   % Initial mass of antibiotic (kg)
n0(4) = Vinit;       % Initial volume (m3)

% Call of differential equation solver

options = odeset('RelTol', 1e-6, 'AbsTol', 1e-8, 'InitialStep', 0.01);
[T,N] = ode45(@f,tspan,n0,options,Km,KI,mumax,kd,Yxs,Ypx,Q,cSin);

% Output

figure(1)
plot(T,N(:,1:3))
xlabel('Time (s)');
ylabel('Amount (kg)');

V = N(:,4);
C = N(:,1:3);
for j = 1:3
    C(:,j) = C(:,j)./V;
end
figure(2)
plot(T,N(:,4))
xlabel('Time(s)');
ylabel('Volume (m3)');
figure(3)
plot(T,C)
xlabel('Time (s)');
ylabel('Concentration (kg/m3)');
T
C
[s1,s2] = size(T);

